/*
   XBlast Robot File

   (C) by Mark Weyer
*/

#local neck_length = 0.6;
#local head_rad = 0.3;
#local eye_y = 3/4;
#local eye_ang = 30;
#local eye_rad = head_rad/4;

#include "humanoid_frames.inc"

Erase_humanoid_input_constants()

#declare leg_length = 1.7;
#declare leg_half_length = 0.9;
#declare default_rad = 0.2;
#declare back_length = 1.5;
#declare arm_length = 1.5;
#declare arm_half_length = 0.8;
#declare leg_sep = 0.3;
#declare arm_sep = 0.3;

#declare killed_leg_ang = 45;
#declare killed_back_ang = 10;
#declare killed_nod_ang = 45;
#declare losing_back_ang = 10;
#declare losing_shake_ang = 60;
#declare winning_jump_height = 0.6;
#declare walking_back_ang = 10;
#declare walking_arm_ang = 30;

#declare left_eye_pos =
  vrotate(<0,neck_length+head_rad*(2*eye_y-1),-head_rad>,-30*y);
#declare left_eye_normal = vrotate(-z,-eye_ang*y);

Define_humanoid_output_constants()

#declare rst=seed(3);

#macro limb(Width1,Width2,Height,Depth,Offset,tr,C)
  #local Length = 0.4;
  #local Thick = 0.2;

  #local i=0;
  #while (i<(Width1+Width2)*Height*Depth*300)
    #local p1=<(2*rand(rst)-1)*Width2,
      rand(rst)*Height+Offset,
      (2*rand(rst)-1)*Depth>;
    #local p2=p1+Length*(2*<rand(rst),rand(rst),rand(rst)>-1);
    #local Y1=(p1.y-Offset)/Height;
    #local Y2=(p2.y-Offset)/Height;
    #local Width_p1 = Width1*(1-Y1)+Width2*Y1;
    #local Width_p2 = Width1*(1-Y2)+Width2*Y2;
    #local r1=sqrt(pow(p1.x/Width_p1,2)+pow(p1.z/Depth,2));
    #local r2=sqrt(pow(p2.x/Width_p2,2)+pow(p2.z/Depth,2));
    #if ((r1<1) & (r2<1) &
        (0<Y2) & (Y2<1) &
        (vlength(p1-p2)<Length))

      cylinder {p1 p2 Thick 1 pigment {rgb <C.x,C.y,C.z>} transform tr}

      #local i=i+1;
    #end
  #end
#end

#macro limb1(Height,tr,C)
  limb(default_rad,default_rad,Height,default_rad,-Height,tr,C)
#end

#local left_eye_trans =
  transform {
    rotate -90*x
    rotate -eye_ang*y
    translate (neck_length+head_rad*(2*eye_y-1))*y
    head_trans
  }
#local right_eye_trans =
  transform {
    rotate -90*x
    rotate eye_ang*y
    translate (neck_length+head_rad*(2*eye_y-1))*y
    head_trans
  }

blob {
  limb1(lower_leg_length,left_lower_leg_trans,handsFeetColor)
  limb1(lower_leg_length,right_lower_leg_trans,handsFeetColor)
  limb1(upper_leg_length,left_upper_leg_trans,armsLegsColor)
  limb1(upper_leg_length,right_upper_leg_trans,armsLegsColor)
  limb(hip_width/2,shoulder_width/2,back_length,2*default_rad,-back_length,
    back_trans,bodyColor)
  limb(default_rad,default_rad,neck_length,default_rad,0,head_trans,bodyColor)
  limb(head_rad,head_rad,2*head_rad,head_rad,neck_length-head_rad,
    head_trans,faceColor)
  limb(eye_rad,eye_rad,2*eye_rad,eye_rad,head_rad-eye_rad*2/3,
    left_eye_trans,helmetColor)
  limb(eye_rad,eye_rad,2*eye_rad,eye_rad,head_rad-eye_rad*2/3,
    right_eye_trans,helmetColor)
  limb1(upper_arm_length,left_upper_arm_trans,armsLegsColor)
  limb1(lower_arm_length,left_lower_arm_trans,handsFeetColor)
  limb1(upper_arm_length,right_upper_arm_trans,armsLegsColor)
  limb1(lower_arm_length,right_lower_arm_trans,handsFeetColor)

  threshold 0.2
  pigment {rgb 1}
  rotate playerAngle*y
  translate playerLocation
  translate -2*z
}

